#ifndef SERVEUR_H
#define SERVEUR_H

#include "package.h"
#include "client.h"
#include <vector.h>
#include <winsock2.h>

class Serveur
{
    private :
        // socket de connection du serveur
        SOCKET m_Socket;
        // structure contenant l'adresse et le port du connection du serveur
        SOCKADDR_IN m_Adresse;
        // vecteur contenant la liste des instances des clients
        vector<Client*> m_listClient;
        // package qui contient les donnes  envoyer  tout les clients
        Package m_Package;
        //Nombre de joueurs max du serveur et non pas effectivement
        // connects
        int m_iNbClients;
        
        // attend la conection d'un client et ajoute ce client dans la liste
        // des clients
        void acceptUnClient();        

        // envoie le nom de tous les joueurs au client point par pClient
        void sendNames(Client * pClient); 
    public :
        
        //constructeur par defaut
        Serveur(int iNbClients);
        
        // retourne le nombre de clients connectes du serveur
        int getNbClientsConnectes();
        
        //destructeur
        ~Serveur();
        
        //attends que tous les clients sont prts
        // et leur envoie le nom de chaque client
        void waitClientsReady();
        
        // envoie le go  tous les clients
        void sendGo();
        
        // Attend la connection de tous les clients
        void acceptClients();
        
        // vrifie si tous les clients sont connects et les fait sortir de 
        // la partie sinon
        void ckeckClientsConnected();
        
        // rempli le package avec tous les evnements des clients
        void createPackage();
        
        // envoie le package  tous les clients
        void sendPackage();
        
        // rejette un client de la partie
        void kickClient(int iNumClient);
        
};

#endif
